unit apptypes;

interface

uses AppTypesDB, System.Web.UI, System.Drawing, System.Web.UI.WebControls;

type csAppTypes = Class(System.Web.UI.WebControls.Table)
    constructor Create;
end;


implementation

type
  TItemTemplate = Class(System.Object,ITemplate)
     procedure InstantiateIn(container:System.Web.UI.Control);
     procedure DoDataBinding(Sender: System.Object; E: System.EventArgs);
     procedure DoNRDataBinding(Sender: System.Object; E: System.EventArgs);
end;


type
  TPayTypeItemTemplate = Class(System.Object,ITemplate)
     procedure InstantiateIn(container:System.Web.UI.Control);
     procedure DoDataBinding(Sender: System.Object; E: System.EventArgs);
     procedure DoNRDataBinding(Sender: System.Object; E: System.EventArgs);
end;

procedure TItemTemplate.DoDataBinding(Sender: System.Object; E:System.EventArgs);
var
    l:System.Web.UI.WebControls.HyperLink;
    container: System.Web.UI.WebControls.DataListItem;
begin
    l:=(Sender as System.Web.UI.WebControls.HyperLink);
    container := (l.NamingContainer as System.Web.UI.WebControls.DataListItem);
    l.Text := DataBinder.Eval((Container as DataListItem).DataItem, 'apptype').ToString;
    l.NavigateURL:='webform3.aspx?apptype=' + l.Text;
    l.Text := '<b>' + l.Text + '</b>';
    container.CssClass:='listCat';
end;

procedure TItemTemplate.DoNRDataBinding(Sender: System.Object; E:System.EventArgs);
var
    l:System.Web.UI.WebControls.Literal;
    container: System.Web.UI.WebControls.DataListItem;
begin
    l:=(Sender as System.Web.UI.WebControls.Literal);
    container := (l.NamingContainer as System.Web.UI.WebControls.DataListItem);
    l.Text := '[' + DataBinder.Eval((Container as DataListItem).DataItem, 'ct').ToString + ']  ';
    container.CssClass:='listCat';
end;

procedure TItemTemplate.InstantiateIn(container:System.Web.UI.Control);
 var
    aHL : System.Web.UI.WebControls.HyperLink;
    aNR : System.Web.UI.WebControls.Literal;
begin

 aNR := System.Web.UI.WebControls.Literal.Create;
 aNR.add_DataBinding(DoNRDataBinding);
 container.Controls.Add(aNR);

 aHL := System.Web.UI.WebControls.HyperLink.Create;
 aHL.add_DataBinding(DoDataBinding);
 container.Controls.Add(aHL);
end;

procedure TPayTypeItemTemplate.DoDataBinding(Sender: System.Object; E:System.EventArgs);
var
    l:System.Web.UI.WebControls.HyperLink;
    container: System.Web.UI.WebControls.DataListItem;
begin
    l:=(Sender as System.Web.UI.WebControls.HyperLink);
    container := (l.NamingContainer as System.Web.UI.WebControls.DataListItem);
    l.Text := DataBinder.Eval((Container as DataListItem).DataItem, 'apppaytype').ToString;
    l.NavigateURL:='webform3.aspx?apppaytype=' + l.Text;
    l.Text := '<b>' + l.Text + '</b>';
    container.CssClass:='listCat';
end;

procedure TPayTypeItemTemplate.DoNRDataBinding(Sender: System.Object; E:System.EventArgs);
var
    l:System.Web.UI.WebControls.Literal;
    container: System.Web.UI.WebControls.DataListItem;
begin
    l:=(Sender as System.Web.UI.WebControls.Literal);
    container := (l.NamingContainer as System.Web.UI.WebControls.DataListItem);
    l.Text := '[' + DataBinder.Eval((Container as DataListItem).DataItem, 'ct').ToString + ']  ';
    container.CssClass:='listCat';
end;

procedure TPayTypeItemTemplate.InstantiateIn(container:System.Web.UI.Control);
 var
    aHL : System.Web.UI.WebControls.HyperLink;
    aNR : System.Web.UI.WebControls.Literal;
begin

 aNR := System.Web.UI.WebControls.Literal.Create;
 aNR.add_DataBinding(DoNRDataBinding);
 container.Controls.Add(aNR);

 aHL := System.Web.UI.WebControls.HyperLink.Create;
 aHL.add_DataBinding(DoDataBinding);
 container.Controls.Add(aHL);
end;


constructor csAppTypes.Create;
var
  products : TAppTypesDB;
  MyList: System.Web.UI.WebControls.DataList; //DataGrid
  ListAppPayType: System.Web.UI.WebControls.DataList; //DataGrid
begin
    inherited create;
		
		Style.Add('background-color','#436A8C');
		Width := System.Web.UI.WebControls.Unit.Percentage(100);
		BorderWidth := System.Web.UI.WebControls.Unit.Pixel(0);
		CellSpacing := 2;
		CellPadding := 0;
		BackColor := Color.WhiteSmoke;
				
    products := TAppTypesDB.Create;
		
    Rows.Add(TableRow.Create);
		Rows[0].Cells.Add(TableCell.Create);
		(Rows[0].Cells[0] as TableCell).Text:='&nbsp;<B>BY CATEGORY</B>';
		(Rows[0].Cells[0] as TableCell).CssClass := 'MenuCaption';
		(Rows[0].Cells[0] as TableCell).HorizontalAlign := System.Web.UI.WebControls.HorizontalAlign.Center;

    MyList := System.Web.UI.WebControls.DataList.Create;
    MyList.ItemTemplate := TItemTemplate.create;
    MyList.DataSource := products.GetProductCategories;
    MyList.DataBind;
    Rows.Add(TableRow.Create);
		Rows[1].Cells.Add(TableCell.Create);
		(Rows[1].Cells[0] as TableCell).BackColor:=Color.WhiteSmoke;
		Rows[1].Cells[0].Controls.Add(MyList);
		(Rows[1].Cells[0] as TableCell).Style.Add('padding-left','3px');
		(Rows[1].Cells[0] as TableCell).Style.Add('padding-right','3px');
		(Rows[1].Cells[0] as TableCell).Style.Add('padding-top','3px');
		(Rows[1].Cells[0] as TableCell).Style.Add('padding-bottom','3px');
		
    Rows.Add(TableRow.Create);
		Rows[2].Cells.Add(TableCell.Create);
		(Rows[2].Cells[0] as TableCell).Text:='&nbsp;<B>BY TYPE</B>';
		(Rows[2].Cells[0] as TableCell).CssClass := 'MenuCaption';
		(Rows[2].Cells[0] as TableCell).HorizontalAlign := System.Web.UI.WebControls.HorizontalAlign.Center;

    ListAppPayType := System.Web.UI.WebControls.DataList.Create;
    ListAppPayType.ItemTemplate := TPayTypeItemTemplate.create;
    ListAppPayType.DataSource := products.GetPayTypeCategories;
    ListAppPayType.DataBind;
    Rows.Add(TableRow.Create);
		Rows[3].Cells.Add(TableCell.Create);
		(Rows[3].Cells[0] as TableCell).BackColor:=Color.WhiteSmoke;
		Rows[3].Cells[0].Controls.Add(ListAppPayType);
		(Rows[3].Cells[0] as TableCell).Style.Add('padding-left','3px');
		(Rows[3].Cells[0] as TableCell).Style.Add('padding-right','3px');
		(Rows[3].Cells[0] as TableCell).Style.Add('padding-top','3px');
		(Rows[3].Cells[0] as TableCell).Style.Add('padding-bottom','3px');
		
		MyList.Free;
		ListAppPayType.Free;
		products.Free;
end;


end.
